package i18n;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
public final class BreakIteratorDemo {
    public static void main(final String[] args) {
        print(Locale.CHINESE, "該文本是中文的特殊文本，出於說明目的，是辛勤工作的一部分。 這是第二句話。 這是第三句話。");
        Locale bnIn = new Locale.Builder().setLanguage("bn").setRegion("IN").build();
        print(bnIn, "এই পাঠ্যটি বাংলায় একটি বিশেষ পাঠ, বিক্ষোভমূলক উদ্দেশ্যে যা কঠোর পরিশ্রমের অংশ হিসাবে অর্পণ করা হয়েছে। এটি দ্বিতীয় বাক্য। এবং এটি তৃতীয় বাক্য।");
    }

    private static void print(final Locale locale, final String text) {
        System.out.println("Locale: " + locale.getDisplayName(Locale.ENGLISH));
        System.out.println("Test  : " + text);
        print(text, "chars", BreakIterator.getCharacterInstance(locale));
        print("words", split(text, BreakIterator.getWordInstance(locale)).stream()
                .filter(word -> word.codePoints().anyMatch(Character::isLetter))
                .collect(Collectors.toList()));
        print(text, "line breaks", BreakIterator.getLineInstance(locale));
        print(text, "sentences", BreakIterator.getSentenceInstance(locale));
        System.out.println();
    }

    private static void print(final String text, final String kind, final BreakIterator boundary) {
        print(kind, split(text, boundary));
    }

    private static void print(final String kind, final List<String> parts) {
        System.out.format("\t%2d %-12s: %s%n", parts.size(), kind, parts);
    }

    private static List<String> split(final String text, final BreakIterator boundary) {
        boundary.setText(text);
        final List<String> parts = new ArrayList<>();
        for (
                int begin = boundary.first(), end = boundary.next();
                end != BreakIterator.DONE;
                begin = end, end = boundary.next()
        ) {
            parts.add(text.substring(begin, end));
        }
        return parts;
    }
}
